/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class GetResource {
    private static void printUsage() {
        System.err.println("Usage:\njava -cp <classpath> util.GetResource <resource1> <resource2> ... ");
        System.err.println("Extracts the resources as found in classpath.");
        System.err.println("Useful for extracting properties file embedded in a jar.");
        System.err.println("Exampe: java -cp pe.jar util.GetResources filenet/vw/base/logging/fnlog4j.properties");
        System.err.println("to retrieve the fnlog4j.properties useful for enabling tracing (if present in the ");
        System.err.println("application's JRE\\lib directory -- has Windows-style filenames).");
        System.err.println("Some other useful properties:  filenet/vw/base/logging/fnlog4j_params.xml");
        System.exit(1);
    }

    public static void main(String[] args) {
        int nArgs;
        int n = nArgs = args == null ? 0 : args.length;
        if (nArgs == 0) {
            GetResource.printUsage();
        }
        for (int i = 0; i < nArgs; ++i) {
            try {
                String line;
                ClassLoader cl = GetResource.class.getClassLoader();
                URL resourceLoc = cl.getResource(args[i]);
                System.out.println("---------------------------------");
                System.out.println("Resource Location=" + resourceLoc);
                System.out.println("---------------------------------");
                InputStream in = cl.getResourceAsStream(args[i]);
                if (in == null) {
                    System.err.println("Can't find " + args[i]);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
                reader.close();
                in.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

